setwd("<your path here>")
df1 <- read.csv("20191114 Example 16.1 Multivariate Data.csv")

attach(df1)
# the dataset has 11 columns:
# Group, X0-X9
library(MASS)
n.clusters <- 3
input.data <- data.frame(cbind(X0,X1,X2,X3,X4,X5,X6,X7,X8,X9))
clusk <- kmeans(input.data,centers=n.clusters)
cluster.id <- clusk$cluster
p.comps <- princomp(input.data,cor=TRUE,scores=TRUE)
#
linear.disc <- lda(df1$Group ~.,df1)
lda.pred <- predict(linear.disc)
#
data.w.pcomps <- cbind(input.data,df1$Group,cluster.id,lda.pred$class,p.comps$scores)
detach(df1)
attach(data.w.pcomps)
pc1.1 <- Comp.1[which(cluster.id==1)]
pc2.1 <- Comp.2[which(cluster.id==1)]
pc1.2 <- Comp.1[which(cluster.id==2)]
pc2.2 <- Comp.2[which(cluster.id==2)]
pc1.3 <- Comp.1[which(cluster.id==3)]
pc2.3 <- Comp.2[which(cluster.id==3)]
#pc1.4 <- Comp.1[which(cluster.id==4)]
#pc2.4 <- Comp.2[which(cluster.id==4)]

plot(pc1.1,pc2.1,main="Cluster Assignment",pch=1,xlim=c(-3.5,10),ylim=c(-3,3),xlab="Prin.Comp. 1",ylab="Prin.Comp 2")
points(pc1.2,pc2.2,pch=2)
points(pc1.3,pc2.3,pch=3)
#points(pc1.4,pc2.4,pch=4)
legend(x=6,y=-1,legend=c("Cluster 1","Cluster 2","Cluster 3"),pch=c(1,2,3))
#legend(x=6,y=-1,legend=c("Cluster 1","Cluster 2","Cluster 3","Cluster 4"),pch=c(1,2,3,4))

#

